/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#ifndef __tOEMIMP_H
#define __tOEMIMP_H

#if !defined(SIXTEEN_BIT_ADDRESSING) && defined(WIN32) 
/* windows based include files are not available on sixteen bit platform*/
#include <windows.h>
#include <winbase.h>
#else
#define S_OK                                   (0x00000000L)
#define S_FALSE                                (0x00000001L)
#define E_FAIL                           	   (0x80004005L)
#endif

#if 1 /*ndef __unix__*/
	#define DX_VOS_Utf8ToWChar DX_VOS_Utf8ToUtf16
#else
	#define DX_VOS_Utf8ToWChar DX_VOS_Utf8ToUtf32
#endif



#include "drmcommon.h"
#include "oemimpl.h"
#include "drmcontextsizes.h"

#ifdef __cplusplus
extern "C" {
#endif


/*************
The following platform dependent functions are used by test code
**************/

#ifdef SIXTEEN_BIT_ADDRESSING
/* DoTest uses the following two functions to compile a list of test case files. These functions 
are modified for 16-bit platform.*/
DRM_RESULT DRM_API tGetTCFileList_pfd(char *szTestFilePrefix, char **szPlatforms, char ***pszTestFileNames);
void tFreeFileNameList_pfd(char **szTestFileNames);
void wcscat(DRM_WCHAR *wszDestination, const DRM_WCHAR *wszSource);
#else
/*Some calls used in tMoveFile are not available on 16-bit platform*/
DRM_BOOL DRM_API tMoveFile(const DRM_WCHAR *wszSrc, const DRM_WCHAR *wszTarget);
#endif

void DRM_API tDRMSleep(DRM_DWORD dwMillSecond);



void DRM_API tGetDeviceStorePathname(DRM_CONST_STRING *pwszPathname);

#define RMFILE_STORE			0x1		/* Delete the file "c:\wmdrmpd\DRMDeviceStore.hds" */
#define RMFILE_DEVCERT			0x2		/* Delete the file "c:\wmdrmpd\devcert.dat" */
#define RMFILE_DEVCERTTEMPLATE	0x4		/* Delete the file "c:\wmdrmpd\devcerttemplate.dat" */
#define RMFILE_PRVKEY			0x8		/* Delete the file "c:\wmdrmpd\priv.dat" */
#define RMFILE_ALL				0xff	/* Delete everything */
DRM_RESULT DRM_API RemoveDRMFile(DRM_DWORD dwRemove);

DRM_RESULT DRM_API SetDeviceEnv(const DRM_WCHAR *wszDevcertTemplateFileName, const DRM_WCHAR *wszPrvKeyFileName, DRM_BOOL fCreateDevCert);
DRM_RESULT _CopyFileToDRMFolder(const DRM_WCHAR *wszSrc, const DRM_WCHAR *wszDest);

/*	Add options later. Now just set machine time to the secure store as secure clock.
	Refresh date is one-month later.
*/
DRM_RESULT DRM_API tSetSecureClock(DRM_HDS_CONTEXT* poHdsContext, DRM_BYTE* rgbSSTPassword); 

DRM_RESULT DRM_API tGetBBContext(DRM_BB_CONTEXT **ppBB);
void DRM_API tFreeBBContext(DRM_BB_CONTEXT *pBB);
void DRM_API tGetBBVersion(DRM_BB_CONTEXT *pBB, DRM_BYTE *pBBVer);

/* DoTest uses the following two functions to compile a list of test case files. */
DRM_RESULT DRM_API tGetTCFileList(char *szTestFilePrefix, char **szPlatforms, char ***pszTestFileNames);
void tFreeFileNameList(char **szTestFileNames);


#ifndef min
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif

extern DRM_BOOL OEM_isdigit(DRM_BYTE ch);
extern DRM_BOOL OEM_isspace(DRM_BYTE ch);
extern DRM_INT  OEM_atoi(const char * str );
extern DRM_LONG OEM_atol(const char * str );
extern DRM_INT OEM_rand(void);
extern DRM_BOOL OEM_isdigit(DRM_BYTE ch);
extern DRM_BOOL OEM_isspace(DRM_BYTE ch);
extern DRM_UINT OEM_mbstowcs(DRM_WCHAR *destination,const char *source,int  length);
extern int OEM_wcstombs (char *destination,const DRM_WCHAR *source,int  length);
extern DRM_WCHAR *OEM_wcsstr(const DRM_WCHAR *str, const DRM_WCHAR *strSearch );
extern void OEM_wcscat(DRM_WCHAR *wszDestination, const DRM_WCHAR *wszSource);
extern DRM_WCHAR *OEM_wcscpy(DRM_WCHAR *dest, const DRM_WCHAR *src);


#ifdef PERF_TEST
	DRM_UINT64 DRM_API GetTimer(void);
	DRM_RESULT DRM_API InitPerfLog( DRM_CHAR* pszLogFileName );
	DRM_RESULT DRM_API ClosePerfLog();
	void DRM_API PerfLog( DRM_CHAR* pszCounter, DRM_UINT64 llVlaue );

/* Code for getting Latency inoformation for DRM Manager function calls */

	#define START_PERFLOG(x) {InitPerfLog( (x) );}
	#define STOP_PERFLOG {ClosePerfLog();}
	#define START_TIMER(x) {(x)= GetTimer();}
	#define STOP_TIMER(x,y,z) { (z) = DRM_UI64Sub(GetTimer(), (y)); PerfLog( (x), (z) );}
#else
	#define START_PERFLOG(x)
	#define STOP_PERFLOG
	#define START_TIMER(x)
	#define STOP_TIMER(x,y,z)
#endif

#ifdef __cplusplus
}
#endif

#endif //__tOEMIMP_H
